package at.supersecure.botnetman.bl;

import at.supersecure.botnetman.beans.Bot;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class BotDB {

    private final File csvFile;

    public BotDB() {
        String workingDir = ".";
        try {
            InitialContext context = new InitialContext();
            Context xmlNode = (Context) context.lookup("java:comp/env");
            workingDir = (String) xmlNode.lookup("workingDir");
        } catch (NamingException ex) {
            Logger.getLogger(BotDB.class.getName()).log(Level.INFO, null, ex);
        }
        csvFile = new File(workingDir, "botnetman.csv");
    }
    
    public boolean botExists(String username) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(csvFile));
            
            String line;
            while ((line = br.readLine()) != null) {
                if (line.length() < username.length() + 1)
                    continue;
                
                if (line.substring(0, username.length() + 1).contains(";")
                        && line.substring(0, username.length()).equals(username)) {
                    return true;
                }
            }
            
        } catch (IOException ex) {
            Logger.getLogger(BotDB.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        
        return false;
    }

    public List<Bot> getAllBots() {
        ArrayList<Bot> list = new ArrayList<>();
        
        try {
            BufferedReader br = new BufferedReader(new FileReader(csvFile));
            
            String line;
            while ((line = br.readLine()) != null) {
                if (!line.contains(";"))
                    continue;
                
                String s0 = line.substring(0, line.indexOf(';'));
                String s1 = line.substring(line.indexOf(';') + 1);

                if (!s1.contains(";"))
                    continue;

                String s2 = s1.substring(0, s1.indexOf(';'));
                String s3 = s1.substring(s1.indexOf(';') + 1);
                
                list.add(new Bot(s0, s2, s3));
            }
            
        } catch (IOException ex) {
            Logger.getLogger(BotDB.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        
        return list;
    }
    
    public boolean addBot(Bot bot) {
        try {
            String line = bot.getUsername() + ";" + bot.getPassword() + ";" + bot.getStatus() + "\n";
            
            int down = 2;
            for (int index = line.indexOf(';', 0); index > -1; index = line.indexOf(';', index + 1)) {
                down--;
            }
            
            if (down != 0) {
                return false;
            }
            
            try (FileWriter fw = new FileWriter(csvFile, true)) {
                fw.write(line);
            }
            
        } catch (IOException ex) {
            Logger.getLogger(BotDB.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        
        return true;
    }
    
    public String loginBot(String username, String password) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(csvFile));
            
            String line;
            while ((line = br.readLine()) != null) {
                if (line.length() < username.length() + 1)
                    continue;
                
                if (line.substring(0, username.length() + 1).contains(";")
                        && line.substring(0, username.length()).equals(username)) {
                    int idx = line.indexOf(';', line.indexOf(';') + 1);
                    if (!line.substring(username.length() + 1, idx > -1 ? idx : line.length())
                            .equals(password)) {
                        return "Wrong password for user " + line.substring(0, username.length() + 1)
                                + " please check your input and try again.";
                    }
                    
                    return null;
                }
            }
            
        } catch (IOException ex) {
            Logger.getLogger(BotDB.class.getName()).log(Level.SEVERE, null, ex);
            return "Error occurred";
        }
        
        return "User not found.";
    }
    
    public Bot getBot(String username) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(csvFile));
            
            String line;
            while ((line = br.readLine()) != null) {
                if (line.length() < username.length() + 1)
                    continue;
                
                if (line.substring(0, username.length() + 1).contains(";")
                        && line.substring(0, username.length()).equals(username)) {
                    if (!line.contains(";"))
                        continue;
                
                    String s0 = line.substring(0, line.indexOf(';'));
                    String s1 = line.substring(line.indexOf(';') + 1);

                    if (!s1.contains(";"))
                        continue;

                    String s2 = s1.substring(0, s1.indexOf(';'));
                    String s3 = s1.substring(s1.indexOf(';') + 1);

                    return new Bot(s0, s2, s3);
                }
            }
        } catch (IOException ex) {
            Logger.getLogger(BotDB.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        
        return null;
    }

    public boolean updateStatus(String username, String status) {
        ArrayList<String> lines = new ArrayList<>();
        int di = -1;
        try {
            Bot bot = getBot(username);
            
            if (bot == null)
                return false;
            
            bot.setStatus(status);

            if (!addBot(bot))
                return false;
            
            try (BufferedReader br = new BufferedReader(new FileReader(csvFile))) {
                int i = 0;
                String line;
                while ((line = br.readLine()) != null) {
                    if (line.length() < username.length() + 1)
                        continue;

                    if (line.substring(0, username.length() + 1).contains(";")
                            && line.substring(0, username.length()).equals(username)
                            && di < 0) {
                        di = i;
                    }

                    lines.add(line);
                    i++;
                }
            }
            
            if (di < 0)
                return false;
            
            lines.remove(di);
            
            try (FileWriter fw = new FileWriter(csvFile)) {
                for (String wLine : lines) {
                    fw.write(wLine + '\n');
                }
            }
        } catch (IOException ex) {
            Logger.getLogger(BotDB.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        
        return true;
    }
}
