
package at.supersecure.botnetman.bl;

import at.supersecure.botnetman.beans.Bot;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class BotManager {
    
    private static final BotManager INSTANCE = new BotManager();
    
    private final BotDB db = new BotDB();
    
    public static BotManager getInstance() {
        return INSTANCE;
    }
    
    public Collection<Bot> getRegisteredBots() {
        return db.getAllBots();
    }
    
    public boolean register(String username, String password) {
        if (username == null || password == null)
            return false;
        if (db.botExists(username))
            return false;
        db.addBot(new Bot(username, password, "new"));
        return true;
    }
    
    public String login(String username, String password) {
        return db.loginBot(username, password);
    }
    
    public Bot getAuthenticatedUser(String username) {
        return db.getBot(username);
    }
    
    public boolean updateStatus(String username, String status) {
        if (!db.updateStatus(username, status))
            return false;
        return true;
    }
}
