package at.supersecure.botnetman.servlets;

import at.supersecure.botnetman.bl.BotManager;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet(name = "Login", urlPatterns = {"/Login"})
public class LoginServlet extends HttpServlet {

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        request.getRequestDispatcher("jsp/login.jsp").forward(request, response);
    }
    
    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        String username = request.getParameter("user");
        String password = request.getParameter("pass");
        
        String msg = BotManager.getInstance().login(username, password);
        if (msg == null) {
            request.getSession().setAttribute("authenticated", true);
            response.sendRedirect("Status?user="+username);
        } else {
            request.setAttribute("message", msg);
            doGet(request, response);
        }
    }
}
