package at.supersecure.botnetman.servlets;

import at.supersecure.botnetman.bl.BotManager;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet(name = "Status", urlPatterns = {"/Status"})
public class StatusServlet extends HttpServlet {

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        if (request.getSession().getAttribute("authenticated") != Boolean.TRUE)
        {
            response.sendRedirect("Login");
            return;
        }
        request.getRequestDispatcher("jsp/status.jsp").forward(request, response);
    }
    
    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        if (request.getSession().getAttribute("authenticated") != Boolean.TRUE)
        {
            response.sendRedirect("Login");
            return;
        }
        
        String user = request.getParameter("user");
        String status = request.getParameter("status");
        
        if (BotManager.getInstance().updateStatus(user, status)) {
            request.setAttribute("message", "Successfully updated status.");
        } else {
            request.setAttribute("message", "Oops! An error occured.");
        }
        request.getRequestDispatcher("jsp/status.jsp").forward(request, response);
    }
}
