<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>

<%@page import="at.supersecure.botnetman.beans.Bot"%>
<%@page import="at.supersecure.botnetman.bl.BotManager"%>
<%@page contentType="text/html" pageEncoding="UTF-8"%>

<% Bot bot = BotManager.getInstance().getAuthenticatedUser(request.getParameter("user")); %>
<% if (bot != null) request.setAttribute("username", bot.getUsername()); %>
<% if (bot != null) request.setAttribute("status", bot.getStatus()); %>
<% request.setAttribute("allBots", BotManager.getInstance().getRegisteredBots()); %>

<!DOCTYPE html>
<html>
    <head>
        <title>BotnetMan - Register</title>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <link href="css/style.css" rel="stylesheet" type="text/css" />
    </head>
    <body>
        <div class="login-page">
            <div class="form">
                <form class="login-form" method="post">
                    <h1>Status of bot "${fn:escapeXml(username)}"</h1>
                    <input type="text" placeholder="status" name="status" value="${fn:escapeXml(status)}"/>
                    <button>update</button>
                </form>
                <div class="message">${message}</div>
                <p class="message"><a href="Login">Logout</a></p>
            </div>
            <div class="form">
                <h1>List of bots:</h1>
                <c:forEach items="${allBots}" var="bot">
                    <div class="bot-entry">${fn:escapeXml(bot.username)}</div>
                </c:forEach>
            </div>
        </div>
    </body>
</html>