"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const express = require("express");
const logger = require("winston");
exports.logger = logger;
const bodyParser = require("body-parser");
const cookieParser = require("cookie-parser");
const routeRegistry_1 = require("./services/routeRegistry");
require("./routes");
const MESSAGE = Symbol.for('message');
function main() {
    return __awaiter(this, void 0, void 0, function* () {
        configLogger();
        var app = express();
        app.use(bodyParser.urlencoded({ extended: false }));
        app.use(bodyParser.json());
        app.use(cookieParser());
        app.use(express.static(__dirname + '/public'));
        routeRegistry_1.routeRegistry.attachRoutes(app);
        //Anpassen
        app.listen(2843, () => {
            console.log('Started Server');
        });
    });
}
function configLogger() {
    logger.configure({
        level: 'debug',
        format: logger.format((logEntry) => {
            const base = { timestamp: new Date() };
            const json = Object.assign(base, logEntry);
            logEntry[MESSAGE] = `${json.level.toUpperCase()} - ${json.timestamp.toISOString()} - ${json.message}`;
            return logEntry;
        })(),
        transports: [
            new logger.transports.File({ json: false, filename: 'FlagLog.log' }),
            new logger.transports.Console()
        ]
    });
}
void main();
//# sourceMappingURL=main.js.map