"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const routeRegistry_1 = require("../services/routeRegistry");
const flagService_1 = require("../services/flagService");
const routeBase_1 = require("../services/routeTypes/routeBase");
class AddFlagRoute extends routeBase_1.Route {
    constructor() {
        super('post', '/addFlag');
    }
    handler(req, res) {
        return __awaiter(this, void 0, void 0, function* () {
            let flag = req.body.flag;
            let password = req.body.password;
            if (!flag || !password) {
                res.send({ success: false, error: 'No flag or password was given', 'body': req.body });
            }
            yield flagService_1.flagService.addFlag(flag, password);
            res.send({ success: true });
        });
    }
}
routeRegistry_1.routeRegistry.registerRoute(new AddFlagRoute());
//# sourceMappingURL=AddFlag.js.map