"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const fs = require("fs");
const path = require("path");
const lockService_1 = require("./lockService");
const main_1 = require("../main");
class FlagService {
    constructor(directory, fileName) {
        if (!directory) {
            directory = __dirname;
        }
        if (!fileName) {
            fileName = 'flags.json';
        }
        this.file = path.join(directory, fileName);
    }
    getFlagsByPassword(password) {
        return __awaiter(this, void 0, void 0, function* () {
            const fileData = (yield this.readFromFlagFile(this.file));
            // TODO: why does this not work????
            return fileData.flags.filter(x => password || x.password == password);
        });
    }
    addFlag(flag, password) {
        return __awaiter(this, void 0, void 0, function* () {
            yield lockService_1.lockService.lock(this.file, () => __awaiter(this, void 0, void 0, function* () {
                let fileData = yield this.readFromFlagFile(this.file);
                if (!fileData) {
                    fileData = { flags: [] };
                }
                else {
                    if (!fileData.flags.find(f => f.flag == flag)) {
                        fileData.flags.push({ flag: flag, password: password });
                    }
                }
                yield this.writeToFlagFile(this.file, fileData);
            }));
        });
    }
    readFromFlagFile(file) {
        return __awaiter(this, void 0, void 0, function* () {
            let retVal = null;
            if (!fs.existsSync(this.file)) {
                yield this.writeToFlagFile(this.file, { flags: [] });
            }
            else {
                try {
                    const data = fs.readFileSync(this.file, { encoding: 'utf8' });
                    retVal = JSON.parse(data);
                }
                catch (err) {
                    main_1.logger.error(`Unable to read file ${this.file}`, err);
                    console.dir(err);
                }
            }
            return retVal;
        });
    }
    writeToFlagFile(file, data) {
        return __awaiter(this, void 0, void 0, function* () {
            fs.writeFile(this.file, JSON.stringify(data), { encoding: 'utf8' }, (err) => {
                if (err) {
                    console.error(`Unable to write to file ${this.file}`);
                    console.dir(err);
                }
            });
        });
    }
}
exports.flagService = new FlagService();
//# sourceMappingURL=flagService.js.map