"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const logger = require("winston");
class LockService {
    constructor(timeout) {
        this.currentLocks = new Array();
        this.timeout = timeout | 10000; //10 sek
    }
    lock(name, func) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.waitLock(name, func);
        });
    }
    waitLock(name, func) {
        return __awaiter(this, void 0, void 0, function* () {
            while (yield this.isLocked(name)) {
                yield this.wait();
            }
            this.setLock(name);
            yield func();
            this.releaseLock(name);
        });
    }
    setLock(name) {
        logger.debug(`Trying to lock ${name}`);
        this.currentLocks.push(name);
    }
    releaseLock(name) {
        logger.debug(`Trying to release ${name}`);
        if (this.currentLocks.find(x => x == name)) {
            this.currentLocks.splice(this.currentLocks.indexOf(name));
        }
    }
    isLocked(name) {
        return __awaiter(this, void 0, void 0, function* () {
            return !this.currentLocks.indexOf(name);
        });
    }
    wait() {
        return __awaiter(this, void 0, void 0, function* () {
            return new Promise((res, rej) => {
                setTimeout(() => res(), this.timeout);
            });
        });
    }
}
exports.lockService = new LockService();
//# sourceMappingURL=lockService.js.map