"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class RouteRegistry {
    constructor() {
        this.routes = new Map();
    }
    getKey(route) {
        return `${route.method}:${route.path}`;
    }
    registerRoute(route) {
        const key = this.getKey(route);
        if (this.routes.has(key)) {
            throw new Error(`There is already a route ${key}`);
        }
        this.routes.set(key, route);
    }
    attachRoutes(app) {
        for (const route of Array.from(this.routes.values())) {
            route.attach(app);
        }
    }
}
exports.RouteRegistry = RouteRegistry;
exports.routeRegistry = new RouteRegistry();
//# sourceMappingURL=routeRegistry.js.map