"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const bodyParser = require("body-parser");
// import * as winston from 'winston';
const ROUTEBASE = require("./routeBase");
const jsonParser = bodyParser.json({ limit: '10mb' });
class JSONRoute extends ROUTEBASE.Route {
    bodyTransformHandlers() {
        const retVal = super.bodyTransformHandlers();
        retVal.push(jsonParser);
        return retVal;
    }
    handler(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            if (req.method === 'POST' || req.method === 'PUT') {
                if (!req.is('json')) {
                    res.status(400).end();
                    return;
                }
            }
            try {
                const jsonReq = {
                    body: req.body,
                    params: req.params,
                    query: new Map(),
                };
                for (const key of Object.keys(req.query)) {
                    jsonReq.query.set(key, req.query[key]);
                }
                const jsonRes = yield this.process(jsonReq);
                res.json(jsonRes);
            }
            catch (err) {
                // log error (Exception in route ${ this.path }(Url: ${ req.url }));
                this.logError(req, err);
                res.status(400).end();
            }
        });
    }
}
exports.JSONRoute = JSONRoute;
//# sourceMappingURL=jsonRoute.js.map