"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class Route {
    constructor(method, path /*Add possible auth*/) {
        this.method = method;
        this.path = path; /*Add possible auth*/
    }
    bodyTransformHandlers() {
        return new Array();
    }
    logError(req, err) {
        const msg = err.stack || err.message || err.toString();
        //Log error here
        //log('error', req.method, req.url, msg)
    }
    handlers() {
        const handlers = new Array();
        //Add Auth handler here
        //Add Body transform handler here
        handlers.push((req, res, next) => this.handler(req, res, next));
        return handlers;
    }
    attach(router) {
        switch (this.method) {
            case 'get':
                router.get(this.path, this.handlers());
                break;
            case 'post':
                router.post(this.path, this.handlers());
                break;
            case 'put':
                router.put(this.path, this.handlers());
                break;
            case 'delete':
                router.delete(this.path, this.handlers());
                break;
            default:
                throw new Error(`Unknown Http Method ${this.method}`);
        }
    }
}
exports.Route = Route;
//# sourceMappingURL=routeBase.js.map