import * as express from 'express';
import * as logger from 'winston';
import * as bodyParser from 'body-parser';
import * as cookieParser from 'cookie-parser';

import { routeRegistry } from './services/routeRegistry';
import { Route } from './services/routeTypes/routeBase';

import './routes';

export { logger };

const MESSAGE = Symbol.for('message');

async function main() {
    configLogger();

    var app = express();

    app.use(bodyParser.urlencoded({ extended: false }));
    app.use(bodyParser.json());
    app.use(cookieParser());

    app.use(express.static(__dirname + '/public'));
    routeRegistry.attachRoutes(app);

    //Anpassen
    app.listen(2843, () => {
        console.log('Started Server');
    });
}

function configLogger() {
    logger.configure({
        level: 'debug',
        format: (<any>logger).format((logEntry) => {
            const base = { timestamp: new Date() };
            const json = Object.assign(base, logEntry);
            logEntry[MESSAGE] = `${(<string>json.level).toUpperCase()} - ${json.timestamp.toISOString()} - ${json.message}`;
            return logEntry;
        })(),
        transports: [
            new logger.transports.File({ json: false, filename: 'FlagLog.log' }),
            new logger.transports.Console()
        ]
    });
}

void main();
