import * as express from 'express';

import { JSONRoute, IJSONRequest, NOREQUEST, NORESPONSE, NOPARAMS } from '../services/routeTypes/jsonRoute';
import { routeRegistry } from '../services/routeRegistry';
import { flagService } from '../services/flagService';
import { Route } from '../services/routeTypes/routeBase';


interface IResponse {
    text: string;
}

class AddFlagRoute extends Route {
    constructor() {
        super('post', '/addFlag');
    }
    protected async handler(req: express.Request, res: express.Response) {
        let flag = req.body.flag;
        let password = req.body.password;
        if (!flag || !password) {
            res.send({ success: false, error: 'No flag or password was given', 'body': req.body });
        }

        await flagService.addFlag(flag, password);
        res.send({ success: true });
    }
}

routeRegistry.registerRoute(new AddFlagRoute());
