import * as express from 'express';

import { JSONRoute, IJSONRequest, NOREQUEST, NORESPONSE, NOPARAMS } from '../services/routeTypes/jsonRoute';
import { routeRegistry } from '../services/routeRegistry';
import { flagService } from '../services/flagService';
import { Route } from '../services/routeTypes/routeBase';



class GetAllFlagsRoute extends Route {
    constructor() {
        super('get', '/getFlags');
    }
    protected async handler(req: express.Request, res: express.Response) {
        res.send({ flags: await flagService.getFlagsByPassword(req.query.password) });
    }
}
routeRegistry.registerRoute(new GetAllFlagsRoute());


// interface IMainResponse {
//     text: string;
// }

// interface IParams {
//     flag: string[];
// }
// class GetAllFlagsRoute extends JSONRoute<NOREQUEST, IParams, IMainResponse> {
//     constructor() {
//         super('get', '/allFlags');
//     }
//     protected async process(req: IJSONRequest<NOREQUEST, IParams>) {
//         return { text: (await flagService.getFlags()).join(', ') };
//     }
// }