import * as fs from 'fs';
import * as path from 'path';

import { lockService } from './lockService';
import { logger } from '../main';

interface FlagJSON {
    flags: { flag: string, password: string }[];
}

class FlagService {
    private file: string;
    constructor(directory?: string, fileName?: string) {
        if (!directory) {
            directory = __dirname;
        }

        if (!fileName) {
            fileName = 'flags.json';
        }

        this.file = path.join(directory, fileName);
    }

    public async getFlagsByPassword(password?: string) {
        const fileData = (await this.readFromFlagFile(this.file));
        // TODO: why does this not work????
        return fileData.flags.filter(x => password || x.password == password);
    }

    public async addFlag(flag: string, password: string) {
        await lockService.lock(this.file, async () => {
            let fileData: FlagJSON = await this.readFromFlagFile(this.file);

            if (!fileData) {
                fileData = { flags: [] };
            }
            else {
                if (!fileData.flags.find(f => f.flag == flag)) {
                    fileData.flags.push({ flag: flag, password: password });
                }
            }

            await this.writeToFlagFile(this.file, fileData);
        });
    }

    private async readFromFlagFile(file: string) {
        let retVal: FlagJSON = null;

        if (!fs.existsSync(this.file)) {
            await this.writeToFlagFile(this.file, <FlagJSON>{ flags: [] });
        } else {
            try {
                const data = fs.readFileSync(this.file, { encoding: 'utf8' });
                retVal = JSON.parse(data);
            } catch (err) {
                logger.error(`Unable to read file ${this.file}`, err);
                console.dir(err);
            }
        }

        return retVal;
    }

    private async writeToFlagFile(file: string, data: FlagJSON) {
        fs.writeFile(this.file, JSON.stringify(data), { encoding: 'utf8' }, (err) => {
            if (err) {
                console.error(`Unable to write to file ${this.file}`);
                console.dir(err);
            }
        });
    }
}

export const flagService = new FlagService();
