import * as logger from 'winston';

type CallbackFunction = () => Promise<void>;
class LockService {
    private timeout: number;
    constructor(timeout?: number) {
        this.timeout = timeout | 10000; //10 sek
    }

    private readonly currentLocks = new Array<string>();

    public async lock(name: string, func: CallbackFunction) {
        await this.waitLock(name, func);
    }

    private async waitLock(name: string, func: CallbackFunction) {
        while (await this.isLocked(name)) {
            await this.wait();
        }
        this.setLock(name);
        await func();
        this.releaseLock(name);
    }

    private setLock(name: string) {
        logger.debug(`Trying to lock ${name}`);
        this.currentLocks.push(name);
    }

    private releaseLock(name: string) {
        logger.debug(`Trying to release ${name}`);
        if (this.currentLocks.find(x => x == name)) {
            this.currentLocks.splice(this.currentLocks.indexOf(name));
        }
    }

    private async isLocked(name: string) {
        return !this.currentLocks.indexOf(name);
    }

    private async wait() {
        return new Promise((res, rej) => {
            setTimeout(() => res(), this.timeout);
        });
    }
}

export const lockService = new LockService();