import * as express from 'express';

import { Route } from './routeTypes/routeBase';
import { Router } from 'express';

export class RouteRegistry {
    private readonly routes = new Map<string, Route>();
    private getKey(route: Route) {
        return `${route.method}:${route.path}`;
    }

    public registerRoute(route: Route) {
        const key = this.getKey(route);
        if (this.routes.has(key)) {
            throw new Error(`There is already a route ${key}`);
        }
        this.routes.set(key, route);
    }

    public attachRoutes<T>(app: express.IRouter<T>) {
        for (const route of Array.from(this.routes.values())) {
            route.attach(app);
        }
    }
}

export const routeRegistry = new RouteRegistry();