import * as bodyParser from 'body-parser';
import * as express from 'express';
// import * as winston from 'winston';

import * as ROUTEBASE from './routeBase';
export { NOPARAMS, NOREQUEST, NORESPONSE } from './routeBase';

const jsonParser = bodyParser.json({ limit: '10mb' });

export interface IJSONRequest<TRequest, TParams> {
    body: TRequest;
    params: TParams;
    query: Map<string, string>;
    // user: AUTH.User;
}

export abstract class JSONRoute<TRequest, TParams, TResponse> extends ROUTEBASE.Route {
    protected abstract async process(req: IJSONRequest<TRequest, TParams>): Promise<TResponse>;

    protected bodyTransformHandlers() {
        const retVal = super.bodyTransformHandlers();
        retVal.push(jsonParser);
        return retVal;
    }
    protected async handler(req: express.Request, res: express.Response, next: express.NextFunction) {
        if (req.method === 'POST' || req.method === 'PUT') {
            if (!req.is('json')) {
                res.status(400).end();
                return;
            }
        }
        try {
            const jsonReq = {
                body: <TRequest>req.body,
                params: <TParams>req.params,
                query: new Map<string, string>(),
                // user: <AUTH.User>req.user
            };
            for (const key of Object.keys(req.query)) {
                jsonReq.query.set(key, req.query[key]);
            }
            const jsonRes = await this.process(jsonReq);
            res.json(jsonRes);
        } catch (err) {
            // log error (Exception in route ${ this.path }(Url: ${ req.url }));
            this.logError(req, err);
            res.status(400).end();
        }
    }
}