import * as express from 'express';

export type NOREQUEST = undefined;
export type NORESPONSE = undefined;
export type NOPARAMS = undefined;

export type HttpMethod = 'get' | 'post' | 'put' | 'delete';
export abstract class Route {
    constructor(readonly method: HttpMethod, readonly path: string /*Add possible auth*/) {

    }

    protected bodyTransformHandlers() {
        return new Array<express.RequestHandler>();
    }

    protected logError(req: express.Request, err: any) {
        const msg = err.stack || err.message || err.toString();
        //Log error here
        //log('error', req.method, req.url, msg)
    }

    protected handlers() {
        const handlers = new Array<express.RequestHandler>();
        //Add Auth handler here
        //Add Body transform handler here
        handlers.push((req, res, next) => this.handler(req, res, next));
        return handlers;
    }

    public attach<T>(router: express.IRouter<T>) {
        switch (this.method) {
            case 'get':
                router.get(this.path, this.handlers());
                break;
            case 'post':
                router.post(this.path, this.handlers());
                break;
            case 'put':
                router.put(this.path, this.handlers());
                break;
            case 'delete':
                router.delete(this.path, this.handlers());
                break;
            default:
                throw new Error(`Unknown Http Method ${this.method}`);
        }
    }
    protected abstract handler(req: express.Request, res: express.Response, next: express.NextFunction): void;
}