
from flask import current_app, render_template, send_from_directory, Markup
from secretarchive import db, utils


def provide_form(msg='', fname='', active_session=False):
    return render_template('api_file.html',
                           msg=Markup.escape(msg),
                           fname=Markup.escape(fname),
                           active_session=active_session)


def handle_upload(file, user_id, mysql, active_session=False):

    # 0. handle file name
    # print(file, flush=True)
    fname_orig = file.filename
    print("File name:", fname_orig)

    if (fname_orig is None) or (not utils.check_filename(fname_orig)):
        return provide_form(msg="Please choose a valid filename!",
                            active_session=active_session)

    #   a. check file name
    fname_origs = db.get_fname_orig(mysql, user_id)
    if fname_orig is None:
        return provide_form(msg="Something went wrong! Please contact an administrator",
                            active_session=active_session)

    try:
        fname_origs.index(fname_orig)

        return provide_form(msg="You already use that filename!",
                            active_session=active_session)
    except ValueError as e:
        # ValueError means that the file name is not used yet (of the current user)
        pass

    file_counter = db.get_file_counter(mysql, user_id)
    if file_counter is None:
        return provide_form(msg="Something went wrong! Please contact an administrator",
                            active_session=active_session)

    fname = str(user_id) + ':' + str(file_counter)
    hashed_fname = utils.get_hash(fname)

    # 1. create file path
    folder = current_app.config['UPLOAD_FOLDER']
    file_path = utils.get_file_path(hashed_fname, folder)

    if file_path is None:
        return provide_form(msg="Please provide a valid file name",
                            active_session=active_session)

    # 2. save file
    file.save(file_path)

    if not db.create_file(mysql=mysql, user_id=user_id,
                          fname_orig=fname_orig, fname_hashed=hashed_fname):
        return provide_form(msg="Something went wrong! Please contact an administrator",
                            active_session=active_session)

    if not db.increase_file_counter(mysql=mysql, user_id=user_id, counter=file_counter):
        return provide_form(msg="File seems to be uploaded, but something went wrong! Please contact an administrator.",
                            active_session=active_session)


    msg = "File successfully uploaded :)"
    return provide_form(msg=msg, fname=hashed_fname,
                        active_session=active_session)


def provide_file(fname, active_session=False):
    folder = current_app.config['UPLOAD_FOLDER']
    file_path = utils.get_file_path(fname, folder)

    if file_path is None:
        return provide_form(msg="Please provide a valid file name!",
                            active_session=active_session)

    if not utils.file_exists(file_path):
        return provide_form(msg="File does not exist!",
                            active_session=active_session)

    print("file path for getting the file: %s" % file_path, flush=True)

    return send_from_directory(folder, fname, mimetype='text/plain')
