

def user_exists(mysql, name):
    try:
        cur = mysql.connection.cursor()
        print("before check user sql query", flush=True)
        cur.execute("SELECT name FROM users WHERE name='" + name + "';")
        print("after check user sql query", flush=True)

        num_rows = cur.rowcount

        if num_rows > 0:
            return True
    except Exception as e:
        print(e, flush=True)
        return True

    return False


def create_user(mysql, name, pwd, info):
    try:
        cur = mysql.connection.cursor()
        print("before create user sql query", flush=True)
        cur.execute("INSERT INTO users (name, pwd, info) VALUES('" + name + "','" + pwd + "','" + info + "');")
        print("after create user sql query", flush=True)

        mysql.connection.commit()
        return True
    except Exception as e:
        print(e, flush=True)
        return False


def create_session(mysql, user_id, token):
    try:
        cur = mysql.connection.cursor()
        print("before create session sql query", flush=True)
        print("user_id: ", user_id, "token: ", token)
        cur.execute("INSERT INTO sessions (user_id, token) VALUES('" + str(user_id) + "','" + token + "');")
        print("after create session sql query", flush=True)

        mysql.connection.commit()
        return True
    except Exception as e:
        print(e, flush=True)
        return False


def create_file(mysql, user_id, fname_orig, fname_hashed):
    try:
        cur = mysql.connection.cursor()
        print("before create file sql query", flush=True)
        print("user_id: ", user_id, "fname: ", fname_orig)
        cur.execute("INSERT INTO files (user_id, fname_orig, fname_hashed) VALUES('" +
                    str(user_id) + "','" + fname_orig + "','" + fname_hashed + "');")
        print("after create file sql query", flush=True)

        mysql.connection.commit()
        return True
    except Exception as e:
        print(e, flush=True)
        return False


def initialize_file_counter(mysql, user_id):
    counter = 1
    try:
        cur = mysql.connection.cursor()
        print("before init file counter sql query", flush=True)
        print("user_id: ", user_id, "counter: ", counter)
        cur.execute("INSERT INTO file_counters (user_id, file_counter) VALUES('" + str(user_id) + "','" + str(counter) + "');")
        print("after init file counter sql query", flush=True)

        mysql.connection.commit()
        return True
    except Exception as e:
        print(e, flush=True)
        return False


def increase_file_counter(mysql, user_id, counter):
    counter += 1
    print("new counter:", counter, flush=True)
    try:
        cur = mysql.connection.cursor()
        print("before increase file counter sql query", flush=True)
        print("user_id: ", user_id, "counter: ", counter)
        cur.execute("UPDATE file_counters SET file_counter='" + str(counter) + "' WHERE user_id='" + str(user_id) + "';")
        print("after increase file counter sql query", flush=True)

        mysql.connection.commit()
        return True
    except Exception as e:
        print(e, flush=True)
        return False


def get_pwd(mysql, name):
    try:
        cur = mysql.connection.cursor()
        print("before get pwd sql query", flush=True)
        cur.execute("SELECT pwd FROM users WHERE name='" + name + "';")
        print("after  get pwd sql query", flush=True)

        # castle approach: there has to be only one user with that name
        num_rows = cur.rowcount
        if num_rows != 1:
            return None

        result = cur.fetchone()
        pwd = result[0]
        return pwd
    except Exception as e:
        print(e, flush=True)
        return None


def get_name(mysql, user_id):
    try:
        cur = mysql.connection.cursor()
        print("before get name sql query", flush=True)
        cur.execute("SELECT name FROM users WHERE id='" + str(user_id) + "';")
        print("after  get name sql query", flush=True)

        # castle approach: there has to be only one user with that id
        num_rows = cur.rowcount
        if num_rows != 1:
            return None

        result = cur.fetchone()
        name = result[0]
        return name
    except Exception as e:
        print(e, flush=True)
        return None


def get_info(mysql, name):
    try:
        cur = mysql.connection.cursor()
        print("before get info sql query", flush=True)
        cur.execute("SELECT info FROM users WHERE name='" + name + "';")
        print("after  get info sql query", flush=True)

        # castle approach: there has to be only one user with that name
        num_rows = cur.rowcount
        if num_rows != 1:
            return None

        result = cur.fetchone()
        info = result[0]
        return info
    except Exception as e:
        print(e, flush=True)
        return None


def get_user_id(mysql, name):
    try:
        cur = mysql.connection.cursor()
        print("before get user_id sql query", flush=True)
        cur.execute("SELECT id FROM users WHERE name='" + name + "';")
        print("after  get user_id sql query", flush=True)

        # castle approach: there has to be only one user with that name
        num_rows = cur.rowcount
        if num_rows != 1:
            return None

        result = cur.fetchone()
        id = result[0]
        return id
    except Exception as e:
        print(e, flush=True)
        return None


def get_session_token(mysql, user_id):
    try:
        cur = mysql.connection.cursor()
        # print("before get session token sql query", flush=True)
        cur.execute("SELECT token FROM sessions WHERE user_id='" + str(user_id) + "';")
        # print("after  get session token sql query", flush=True)

        # castle approach: there has to be only one token with that user id
        num_rows = cur.rowcount
        if num_rows != 1:
            print("More than one session token for a the user with id '%s'!" % str(user_id), flush=True)
            return None

        result = cur.fetchone()
        token = result[0]
        return token
    except Exception as e:
        print(e, flush=True)
        return None


def get_file_counter(mysql, user_id):
    try:
        cur = mysql.connection.cursor()
        print("before get file counter sql query", flush=True)
        cur.execute("SELECT file_counter FROM file_counters WHERE user_id='" + str(user_id) + "';")
        print("after  get file counter sql query", flush=True)

        # castle approach: there has to be only one file counter with that user id
        num_rows = cur.rowcount
        if num_rows != 1:
            print("More than one file counter for a the user with id '%s'!" % str(user_id), flush=True)
            return None

        result = cur.fetchone()
        file_counter = result[0]
        return file_counter
    except Exception as e:
        print(e, flush=True)
        return None


def get_files(mysql, user_id):
    try:
        cur = mysql.connection.cursor()
        print("before get files sql query", flush=True)
        cur.execute("SELECT fname_orig, fname_hashed FROM files WHERE user_id='" + str(user_id) + "';")
        print("after  get files sql query", flush=True)

        result = [[item[0], item[1]] for item in cur.fetchall()]
        return result
    except Exception as e:
        print(e, flush=True)
        return None


def get_fname_orig(mysql, user_id):
    try:
        cur = mysql.connection.cursor()
        print("before get fname_orig sql query", flush=True)
        cur.execute("SELECT fname_orig FROM files WHERE user_id='" + str(user_id) + "';")
        print("after  get fname_orig sql query", flush=True)

        result = [item[0] for item in cur.fetchall()]
        return result
    except Exception as e:
        print(e, flush=True)
        return None


def delete_session(mysql, user_id):
    try:
        cur = mysql.connection.cursor()
        print("before delete session token sql query", flush=True)
        cur.execute("DELETE FROM sessions WHERE user_id='" + str(user_id) + "';")
        print("after delete session token sql query", flush=True)

        mysql.connection.commit()
        return True
    except Exception as e:
        print(e, flush=True)
        return False
