from flask import Markup, render_template
from secretarchive import db, login_archive


def provide_form(name='', info='', file_count=0, file_info='',
                 active_session=False):
    return render_template('profile.html',
                           name=Markup.escape(name),
                           info=Markup.escape(info),
                           file_count=file_count,
                           file_info=Markup(file_info),
                           active_session=active_session)


def handle(mysql, user_id):
    # 0. get name and info of agent
    name = db.get_name(mysql, user_id)
    info = db.get_info(mysql, name)

    if (name is None) or (info is None):
        return render_template('index.html',
                               msg="An unexpected error occurred! Please contact an administrator.",
                               active_session=True)

    # 1. get agent's files
    files = db.get_files(mysql, user_id)

    if files is None:
        return render_template('index.html',
                               msg="An unexpected error occurred! Please contact an administrator.",
                               active_session=True)

    file_count = len(files)
    file_info = ''

    if file_count > 0:
        file_info = "<ul>"

        for file in files:
            fname_orig   = file[0]
            fname_hashed = file[1]

            file_info += """
            <li><a href='%s'>%s</a></li>
            """ % ('/api/file/' + fname_hashed, fname_orig)

        file_info += "</ul>"

    return provide_form(name=name, info=info,
                        file_count=file_count, file_info=file_info,
                        active_session=True)
