
from flask import render_template, Markup, url_for
from secretarchive import db, utils
# render_template --> blacklist


def provide_form(msg=""):
    return render_template('registration.html', msg=Markup.escape(msg))


def handle(mysql, name, pwd, info):
    hashed_pwd = utils.get_hash(pwd)

    # 0. create user
    if not db.create_user(mysql, name, hashed_pwd, info):
        return provide_form("Failed to create user. Please contact an administrator.")

    # 1. initialize file counter
    user_id = db.get_user_id(mysql=mysql, name=name)
    if user_id is None:
        return provide_form("Failed to create user. Please contact an administrator.")

    if not db.initialize_file_counter(mysql, user_id):
        return provide_form("Failed to create user. Please contact an administrator.")
    else:
        return render_template('index.html',
                               msg="Successfully registered! Now you can login =)",
                               active_session=False)
